unit samdlg;

interface

uses WinTypes, WinProcs, Classes, Graphics, Forms, Controls, Menus, SysUtils,
  StdCtrls, Buttons,  Dialogs, ExtCtrls, AdDialog, Spin;


type
  TAdrockDialogSample = class(TForm)
    StandardDLG: TBitBtn;
    AdrockDLG: TBitBtn;
    ButtonsGroupBox: TGroupBox;
    ButtonYes: TCheckBox;
    ButtonNo: TCheckBox;
    ButtonCancel: TCheckBox;
    ButtonAbort: TCheckBox;
    ButtonRetry: TCheckBox;
    ButtonIgnore: TCheckBox;
    ButtonOK: TCheckBox;
    ButtonALL: TCheckBox;
    ButtonHelp: TCheckBox;
    TimerGroupBox: TGroupBox;
    AutoTimer: TEdit;
    DefaultGroupBox: TGroupBox;
    DefaultYes: TRadioButton;
    DefaultNo: TRadioButton;
    DefaultCancel: TRadioButton;
    DefaultAbort: TRadioButton;
    DefaultRetry: TRadioButton;
    DefaultIgnore: TRadioButton;
    DefaultOK: TRadioButton;
    DefaultALL: TRadioButton;
    SoundGroupBox: TGroupBox;
    SoundNone: TRadioButton;
    SoundICONAsterisk: TRadioButton;
    SoundIconExclamation: TRadioButton;
    MouseGroupBox: TGroupBox;
    CursorDoNotMove: TRadioButton;
    CursorMove: TRadioButton;
    SoundIconHand: TRadioButton;
    SoundIconQuestion: TRadioButton;
    SoundOK: TRadioButton;
    Label1: TLabel;
    StyleGroupBox: TGroupBox;
    StylemtInformation: TRadioButton;
    StylemtConfimation: TRadioButton;
    StylemtWarning: TRadioButton;
    StyleMtError: TRadioButton;
    GetMessage: TEdit;
    WaveFileName: TEdit;
    SpeedButton1: TSpeedButton;
    OpenDialog1: TOpenDialog;
    WaveFileRadioButton: TRadioButton;
    PositionGroupBox: TGroupBox;
    CenterOfScreenRadioButton: TRadioButton;
    CenterOfApplicationRadioButton: TRadioButton;
    BitBtn1: TBitBtn;
    FontDialog1: TFontDialog;
    DialogCaptions: TButton;
    Button2: TButton;
    Panel1: TPanel;
    Label14: TLabel;
    Label13: TLabel;
    Label16: TLabel;
    Label18: TLabel;
    Label20: TLabel;
    Label11: TLabel;
    Label5: TLabel;
    Label74: TLabel;
    Label80: TLabel;
    Label82: TLabel;
    Label84: TLabel;
    Label92: TLabel;
    Label93: TLabel;
    Label94: TLabel;
    SpinEdit1: TSpinEdit;
    Label2: TLabel;
    BitBtn2: TBitBtn;
    Bevel1: TBevel;
    procedure StandardDLGClick(Sender: TObject);
    procedure BitBtn2Click(Sender: TObject);
    procedure BitBtn3Click(Sender: TObject);
    procedure BitBtn4Click(Sender: TObject);
    procedure AdrockDLGClick(Sender: TObject);
    procedure SpeedButton1Click(Sender: TObject);
    procedure WaveFileNameChange(Sender: TObject);
    procedure CenterOfScreenRadioButtonClick(Sender: TObject);
    procedure CenterOfApplicationRadioButtonClick(Sender: TObject);
    procedure BitBtn1Click(Sender: TObject);
    procedure DialogCaptionsClick(Sender: TObject);
    procedure Button2Click(Sender: TObject);
    procedure Button3Click(Sender: TObject);
    procedure SpinEdit1Change(Sender: TObject);
  private
    { Private declarations }
    Procedure ShowMessageResult(Result : Word);
  public
    { Public declarations }
    Function GetButtons : TMsgDlgButtons;
    Function GetDefaultButton : TMsgDlgBtn;
    Function GetSound:Integer;
    Function GetStyle : TMsgDlgType;
  end;

var
  AdrockDialogSample: TAdrockDialogSample;

implementation

{$R *.DFM}

procedure TAdrockDialogSample.StandardDLGClick(Sender: TObject);
begin
     MessageDlg(getmessage.Text, GetStyle, GetButtons, 0);
end;

procedure TAdrockDialogSample.BitBtn2Click(Sender: TObject);
begin
     FontDialog1.Font.Assign(TAdrockMessageDialogButtonFont);
     if (FontDialog1.Execute = TRUE) then
       TAdrockMessageDialogButtonFont.Assign(FontDialog1.Font);
end;

procedure TAdrockDialogSample.BitBtn3Click(Sender: TObject);
begin
     QueryBox('#3, Are you sure that you want to format your hard drive?', mbNo);
end;

procedure TAdrockDialogSample.BitBtn4Click(Sender: TObject);
begin
     ShowMessageResult(MessageDialog('#4, Are you sure that you want to format your hard drive?',
     mtConfirmation, [mbAll, MbYes, MbNo, MbCancel, mbAbort, mbOK, mbRetry, mbIgnore, mbHelp],
     MbNo, MB_ICONEXCLAMATION, 5000, 0));
end;

procedure TAdrockDialogSample.AdrockDLGClick(Sender: TObject);
begin
     SetMessageDialogCursor((CursorDoNotMove.Checked = FALSE), FALSE);
     if (WaveFileRadioButton.Checked= TRUE)then
       ShowMessageResult(MessageDialogWave(getmessage.Text, getStyle,
         GetButtons, GetDefaultButton, WaveFileName.Text, StrToInt(AutoTimer.Text), 0))
     else
       ShowMessageResult(MessageDialog(getmessage.Text, getStyle,
         GetButtons, GetDefaultButton, GetSound, StrToInt(AutoTimer.Text), 0));
end;

Function TAdrockDialogSample.GetStyle : TMsgDlgType;
begin
 if (StylemtInformation.Checked = TRUE) then
    Result := mtInformation
 else if (StylemtConfimation.Checked = TRUE) then
    Result := MtConfirmation
 else if (StylemtWarning.Checked = TRUE) then
    Result := mtWarning
 else
    Result := mtError;
end;

Function TAdrockDialogSample.GetButtons : TMsgDlgButtons;
Var
  Res : TMsgDlgButtons;
begin
  Res := [];
  if (ButtonYes.Checked = TRUE) then
    Res := Res + [mbYes];
  if (ButtonNo.Checked = TRUE) then
    Res := Res + [mbNo];
  if (ButtonCancel.Checked = TRUE) then
    Res := Res + [mbCancel];
  if (ButtonAbort.Checked = TRUE) then
    Res := Res + [mbAbort];
  if (ButtonRetry.Checked = TRUE) then
    Res := Res + [mbRetry];
  if (ButtonIgnore.Checked = TRUE) then
    Res := Res + [mbIgnore];
  if (ButtonOK.Checked = TRUE) then
    Res := Res + [mbOK];
  if (ButtonAll.Checked = TRUE) then
    Res := Res + [mbAll];
  if (ButtonHelp.Checked = TRUE) then
    Res := Res + [mbHelp];
  Result := RES;
end;

Function TAdrockDialogSample.GetDefaultButton : TMsgDlgBtn;
begin
     if (DefaultYes.Checked = TRUE) then
      result := mbYes
     else if (DefaultNo.Checked = TRUE) then
      result := mbNo
     else if (DefaultCancel.Checked = TRUE) then
      result := mbCancel
     else if (DefaultAbort.Checked = TRUE) then
      result := mbAbort
     else if (DefaultRetry.Checked = TRUE) then
      result := mbRetry
     else if (DefaultIgnore.Checked = TRUE) then
      result := mbIgnore
     else if (DefaultOK.Checked = TRUE) then
      result := mbOK
     else
      result := mbAll;
end;


Function TAdrockDialogSample.GetSound:Integer;
begin
  if (SoundNone.Checked = TRUE) then
   result := -1
  else if (SoundICONAsterisk.Checked = TRUE) then
    Result := MB_ICONASTERISK
  else if (SoundIconExclamation.Checked = TRUE) then
    Result := MB_ICONEXCLAMATION
  else if (SoundIconhAND.Checked = TRUE) then
    Result := MB_ICONHAND
  else if (SoundIconQuestion.Checked = TRUE) then
    Result := MB_ICONQuestion
  else
    Result := MB_OK;
end;

Procedure TAdrockDialogSample.ShowMessageResult(Result : Word);
begin
   Case Result of
     mrYes    : informationBox('mrYes');
     mrNo     : informationBox('mrNo');
     mrOK     : informationBox('mrOK');
     mrCancel : informationBox('mrCancel');
     mrAbort  : informationBox('mrAbort');
     mrRetry  : informationBox('mrRetry');
     mrIgnore : informationBox('mrIgnore');
     mrAll    : informationBox('mrAll');
   end;
end;

procedure TAdrockDialogSample.SpeedButton1Click(Sender: TObject);
begin
  OpenDialog1.FileName := WaveFileName.Text;
  if (OpenDialog1.Execute = TRUE) then
   begin
     WaveFileRadioButton.Checked := TRUE;
     WaveFileName.Text := OpenDialog1.FileName;
   end;
end;

procedure TAdrockDialogSample.WaveFileNameChange(Sender: TObject);
begin
       WaveFileRadioButton.Checked := TRUE;
end;

procedure TAdrockDialogSample.CenterOfScreenRadioButtonClick(Sender: TObject);
begin
     ModifyTAdrockMessageDialogPopupPosition(TRUE, AdrockMessageDialogCenterToScreen);
end;

procedure TAdrockDialogSample.CenterOfApplicationRadioButtonClick(Sender: TObject);
begin
     ModifyTAdrockMessageDialogPopupPosition(TRUE, AdrockMessageDialogCenterToApplication);
end;

procedure TAdrockDialogSample.BitBtn1Click(Sender: TObject);
begin
     FontDialog1.Font.Assign(TAdrockMessageDialogFont);
     if (FontDialog1.Execute = TRUE) then
       TAdrockMessageDialogFont.Assign(FontDialog1.Font);
end;

procedure TAdrockDialogSample.DialogCaptionsClick(Sender: TObject);
begin
     { Modify the dialog caption for the next ,tConfirmation Dialog that gets opened }
     ModifyTAdrockMessageDialogCaption(FALSE, mtConfirmation, 'Please confirm...');

     { Modify the caption for the buttons }
     ModifyTAdrockMessageDialogButtonCaption(FALSE, mbYes, 'Backup');
     ModifyTAdrockMessageDialogButtonCaption(FALSE, mbNo,  'False');

     if (QueryBox('As you can see, we have modified the captions of the two buttons below and the caption of the Dialog!'+
        #13+#13+'Please make a selection?', mbYes) = mrNo) then
       InformationBox('Your selection was mrNo, mrNo had the caption "Exit"')
     else
       InformationBox('Your selection was mrYes, mrYes had the caption "Backup"');

     { So with very simple code you can make simple dialogs with better button captions }
end;

procedure TAdrockDialogSample.Button2Click(Sender: TObject);
begin
  BuildTAdrockMessageDialogLine('The TAdrockMessageDialog now supports large dialogs, that is dialogs with more than ');
  BuildTAdrockMessageDialogLine('255 characters of text. The dialog supports up to 16000 bytes of text in the dialog, ');
  BuildTAdrockMessageDialogLine('probally more than would display on the screen.'+#13);

  BuildTAdrockMessageDialogLine(#13);

  BuildTAdrockMessageDialogLine('When using the large dialogs you must call BuildTAdrockMessageDialogLine() ');
  BuildTAdrockMessageDialogLine('passing a string of text to add to the dialog. You must include a #13 or chr(13) to ');
  BuildTAdrockMessageDialogLine('force a line break, as all lines are concatinated together.'+#13);

  BuildTAdrockMessageDialogLine(#13);

  BuildTAdrockMessageDialogLine('You can do a lot of things with a large dialog, display someones details and prompt for ');
  BuildTAdrockMessageDialogLine('the user to do something.'+#13);

  BuildTAdrockMessageDialogLine(#13);

  BuildTAdrockMessageDialogLine('Adrock Software : '+#13#13);
  BuildTAdrockMessageDialogLine(#9+'P.O. Box 13-155'+#13#9+'Christchurch'+#13#9+'New Zealand'+#13#13#13);
  BuildTAdrockMessageDialogLine('Phone'+#9+'64 3 3651-112'+#13);
  BuildTAdrockMessageDialogLine('Fax'+#9+'64 3 3651-112'+#13);

  BuildTAdrockMessageDialogLine(#13);

  BuildTAdrockMessageDialogLine('You will notice that this dialog has two buttons, but the buttons are not standard, they ');
  BuildTAdrockMessageDialogLine('have had their captions modified, and their widths changed. The dialog has been set to ');
  BuildTAdrockMessageDialogLine('open with its width set to '+IntToStr(SpinEdit1.Value)+'% of the Screen Width'+#13);

  BuildTAdrockMessageDialogLine(#13);

  BuildTAdrockMessageDialogLine('Well you must be a keen reader if you got here, please contact us at DHMCC@IBM.NET ');
  BuildTAdrockMessageDialogLine('(Internet) or 770135,110 (CompuServe) if you have any queries.');

     { Modify the mbYes button Caption }
     ModifyTAdrockMessageDialogButtonCaption(FALSE, mbYes, 'Source');

     { Modify the mbNo button Caption }
     ModifyTAdrockMessageDialogButtonCaption(FALSE, mbNo, 'Continue');

     { Resize the Dialog Button Widths }
     TAdrockMessageDialogBtnSize.X := 85;
     BuildTAdrockMessageDialogShow('Please Read On...', mtConfirmation, [mbYes, mbNo], mbYes, -1,-1,-1);
end;

procedure TAdrockDialogSample.Button3Click(Sender: TObject);
begin
  InformationBox('Well since it stinks, tell us why, please Email us at : DHMCC@IBM.Net'+#13#13+
           'Thanks in advance, Chris'+#13+'Adrock Software Development Team');
end;

procedure TAdrockDialogSample.SpinEdit1Change(Sender: TObject);
begin
   { Modify the width of the dialog as a percentage of the screen width }
   ModifyTAdrockMessageDialogOpeningPercentage(TRUE, (Sender as TSpinEdit).Value);
end;

end.

